#include <stddef.h>
#include "OfflineEffect.hpp"

//-----------------------------------------------------------------------------

#if MAC
#pragma export on
#endif

#if BEOS
#define main main_plugin
extern "C" __declspec(dllexport) AEffect *main_plugin (audioMasterCallback audioMaster);

#else
AEffect *main (audioMasterCallback audioMaster);
#endif

AEffect *main (audioMasterCallback audioMaster)
{
	// get vst version
	if (! audioMaster(0, audioMasterVersion, 0, 0, 0, 0))
		return 0;  // old version

	AudioEffect* effect = new OfflineEffect(audioMaster);	//OfflineEdit(audioMaster);
	return effect->getAeffect();
}

#if MAC
#pragma export off
#endif


//-----------------------------------------------------------------------------

#if WIN32
#include <windows.h>
HINSTANCE hInstance;
BOOL WINAPI DllMain (HINSTANCE hInst, DWORD dwReason, LPVOID lpvReserved)
{
	hInstance = hInst;
	return 1;
}
#endif

//-----------------------------------------------------------------------------
